"""CSC148 Exercise 2: Inheritance

=== Module description ===
This module contains sample tests for Exercise 2.

Warning: This is an extremely incomplete set of tests!
Add your own to practice writing tests and to be confident your code is correct.

For more information on hypothesis (one of the testing libraries we're using),
please see
<http://www.teach.cs.toronto.edu/~dema/csc148/exercises/hypothesis.pdf>.

Note: this file is for support purposes only, and is not part of your
submission.
"""
import unittest
from hypothesis import given, settings
from hypothesis.strategies import integers, text
from math import sqrt

from ex2 import SuperDuperManager

class SuperDuperManagerTest(unittest.TestCase):

    @given(text(min_size=1), integers(min_value=1))
    def test_new_car_attributes(self, id_, fuel):
        manager = SuperDuperManager()
        manager.add_vehicle('Car', id_, fuel)
        self.assertEqual(manager.get_vehicle_fuel(id_), fuel)
        self.assertEqual(manager.get_vehicle_position(id_), (0, 0))

    @given(text(min_size=1), integers(min_value=1))
    def test_dummy_car_attributes(self, id_, fuel):
        manager = SuperDuperManager()
        manager.add_vehicle('Car', id_, fuel)
        self.assertEqual(manager.get_vehicle_fuel('dummy'), None)
        self.assertEqual(manager.get_vehicle_position('dummy'), None)

    @given(text(min_size=1), integers(min_value=1))
    def test_new_helicopter_attributes(self, id_, fuel):
        manager = SuperDuperManager()
        manager.add_vehicle('Helicopter', id_, fuel)
        self.assertEqual(manager.get_vehicle_fuel(id_), fuel)
        self.assertEqual(manager.get_vehicle_position(id_), (3, 5))

    @given(text(min_size=1), integers(min_value=1), integers(min_value=1), integers(min_value=1))
    def test_car_move_fuel(self, id_, fuel, new_x, new_y):
        manager = SuperDuperManager()
        manager.add_vehicle('Car', id_, fuel)
        manager.move_vehicle(id_, new_x, new_y)
        remaining_fuel = manager.get_vehicle_fuel(id_)
        dist = new_x + new_y
        expected_fuel = fuel
        if fuel >= dist:
           expected_fuel = fuel - dist
        self.assertEqual(remaining_fuel, expected_fuel)


    @given(text(min_size=1), integers(min_value=1), integers(min_value=0), integers(min_value=0))
    def test_helicopter_move_fuel(self, id_, fuel, new_x, new_y):
        manager = SuperDuperManager()
        manager.add_vehicle('Helicopter', id_, fuel)
        manager.move_vehicle(id_, new_x, new_y)
        remaining_fuel = manager.get_vehicle_fuel(id_)
        dx2 = (new_x - 3) * (new_x - 3)
        dy2 = (new_y - 5) * (new_y - 5)
        dist = sqrt(dx2 + dy2)
        expected_fuel = fuel
        if fuel >= dist:
           expected_fuel = int(fuel - dist)
        self.assertEqual(remaining_fuel, expected_fuel)


    @given(text(min_size=1), integers(min_value=1), integers(min_value=1), integers(min_value=1))
    def test_car_move_position(self, id_, fuel, new_x, new_y):
        manager = SuperDuperManager()
        manager.add_vehicle('Car', id_, fuel)
        manager.move_vehicle(id_, new_x, new_y)
        real_position = manager.get_vehicle_position(id_)
        dist = new_x + new_y
        expected_position = (new_x, new_y)
        if fuel < dist:
           expected_position = (0, 0)
        self.assertEqual(real_position, expected_position)

    @given(text(min_size=1), integers(min_value=1), integers(min_value=0), integers(min_value=0))
    def test_helicopter_move_position(self, id_, fuel, new_x, new_y):
        manager = SuperDuperManager()
        manager.add_vehicle('Helicopter', id_, fuel)
        manager.move_vehicle(id_, new_x, new_y)
        real_position = manager.get_vehicle_position(id_)
        dx2 = (new_x - 3) * (new_x - 3)
        dy2 = (new_y - 5) * (new_y - 5)
        dist = sqrt(dx2 + dy2)
        expected_position = (3, 5)
        if fuel >= dist:
           expected_position = (new_x, new_y)
        self.assertEqual(real_position, expected_position)

    @given(text(min_size=1), integers(min_value=1))
    def test_new_helicopter_attributes(self, id_, fuel):
        manager = SuperDuperManager()
        manager.add_vehicle('Helicopter', id_, fuel)
        self.assertEqual(manager.get_vehicle_fuel(id_), fuel)
        self.assertEqual(manager.get_vehicle_position(id_), (3, 5))

    @given(text(min_size=1), integers(min_value=10))
    def test_new_carpet_attributes(self, id_, fuel):
        manager = SuperDuperManager()
        manager.add_vehicle('UnreliableMagicCarpet', id_, fuel)
        self.assertEqual(manager.get_vehicle_fuel(id_), fuel)
        self.assertLessEqual(abs(manager.get_vehicle_position(id_)[0]), 10)
        self.assertLessEqual(abs(manager.get_vehicle_position(id_)[1]), 10)

    def test_move_carpet(self):
        manager = SuperDuperManager()
        id_ = 'm'
        manager.add_vehicle('UnreliableMagicCarpet', id_, 0)
        new_x, new_y = 5, 5
        rand_coords = False
        tries = 0
        while tries < 1000 and not(rand_coords):
            manager.move_vehicle(id_, new_x, new_y)
            pos_x, pos_y = manager.get_vehicle_position(id_)
            rand_coords = (new_x, new_y) == (pos_x, pos_y)
            tries = tries + 1
        self.assertTrue(rand_coords)

    @given(text(min_size=1), integers(min_value=1), integers(min_value=1), integers(min_value=1))
    def test_carpet_move_position(self, id_, fuel, new_x, new_y):
        manager = SuperDuperManager()
        manager.add_vehicle('UnreliableMagicCarpet', id_, fuel)
        manager.move_vehicle(id_, new_x, new_y)
        remaining_fuel = manager.get_vehicle_fuel(id_)
        dist = new_x + new_y
        expected_fuel = fuel
        self.assertEqual(remaining_fuel, expected_fuel)



if __name__ == '__main__':
    unittest.main()
